/*
   |**********************************************************************;
  Project           : Dashboard Aprilia RS 125 ATMega2560pro
                      -Drehzahl per I2C von Arduino Nano
                      -Ausgabe auf LCD 128x64
                      -Startup Sequenz mit bitmap Ausgabe
                      -Menüseiten per Pushbutton
                      -Temperaturmessung per DS18B20
                      -
  Program name      : 

  Author            : JimmyRR

  Date created      : 20210415

  Modified by       : 

  Revision History  :

  Date modifiied    Vers.   Revision Date
  20210501          1.2     

  |**********************************************************************;
*/

//Datenübertragung Arduino I2C//
#include <I2C_Anything.h>
#include <Wire.h>
const byte MY_ADDRESS = 42; // I2C Adresse
////////////////////////////////

//Display//
#include <U8g2lib.h>
#include <SPI.h>
#include <Arduino.h>
///////////

//Wassertemperatur//
#include <OneWire.h>
#include <DallasTemperature.h>
#define ONE_WIRE_BUS 22  // One Wire Bus für z.B. Temp.fühler an PIN22
//#define TEMPERATURE_PRECISION 9 //Temp.fühler Präzision
///////////////////

//SERVO//
#include <Servo.h>
int middleAngle;  // Servo 50% geöffnet, hälfte des Gesamtbewegungsradius (Wird berechnet)
int Setpoint;
Servo pvservo;

//EEPROM//
#include <EEPROM.h>

//Variablen der Einstellungen und EEPROM Adressen//

byte valBacklight; // Variable für Backlight auf EEPROM
byte valBacklightnew;  // Variable für Backlight bei Veränderung
const int addressBacklight = 16;    //Speicheradresse für valBacklight

byte valBrightness;
byte valBrightnessnew;
const int addressBrightness = 32;

int activeRpm;
int setactiveRpm;
const int addressactiveRpm = 48;

int cutOff;
int setCutOff;
const int addressCutOff = 64;

int delayTime;
int setDelayTime;
const int addressDelayTime = 80;

int open50Rpm;
int setOpen50Rpm;
const int addressOpen50Rpm = 96;
bool pvOpen50=false;

int openRpm;
int setOpenRpm;
const int addressOpenRpm = 97;
bool pvOpen=false;

int openAngle;
int setOpenAngle;
const int addressOpenAngle = 98;

int closeAngle;
int setCloseAngle;
const int addressCloseAngle = 99;


const int addressWaterpump = 112;

//////////

//TABS vorziehen um kompiler Fehler zu umgehen//
void startup();
void setPage1();
void setPage2();
void setPage3();
void setPageSettings();
/////////////////////////////////

//Menü "Settings"//
//Variables for the menu encoder "Page SETTINGS"
int counter = 0;
int counterp = 0; 
int page=1;
int Ready=1;
int submenu=0;
int subsubmenu=0;
int last_counter = 0; 
static const byte sensorPin = 0;

#define PINA 2
#define PINB 7
#define PUSHP 3
#define INTERRUPT 0  // that is, pin 2
#define INTERRUPTB 1  // that is, pin 3


volatile boolean turned;   // rotary was turned
volatile boolean pushed;    // knob was pushed
volatile boolean up;  // true when turned cw

//Pins für Menüfunktionen//
#define Backlightpin 38  // Backlight an Pin 38
#define LEDallOnpin 39   // Pin um alle LEDs einzuschalten
#define Brightness_1 40  // Pin 1 für Helligkeitseinstellung
#define Brightness_2 41  // Pin 2 für Helligkeitseinstellung






// Interrupt Service Routine for a change to pushpin
void isrp ()
{
  if (!digitalRead (PUSHP))
    pushed = true;
}  // end of isr

// Interrupt Service Routine for a change to encoder pin A
void isr ()
{
  if (digitalRead (PINA))
    up = digitalRead (PINB);
  else
    up = !digitalRead (PINB);
  turned = true;
}  // end of isr


//Display//
U8G2_ST7920_128X64_F_SW_SPI u8g2(U8G2_R0, /* clock=*/ 52, /* data=*/ 51, /* CS=*/ 53, /* reset=*/ 8);
const byte btnpin = 37;  // Page Button an Pin 37
byte seite = 1;          // Voreinstellung der Seite
byte maxseite = 4;       // max Anzahl
bool pushedB;    //Merker für pushed Button Rotary
//////////

//Schalter+Taster//
bool button;            // Zustand des Eingangs
bool buttonflag;        // Hilfsflag für den Taster

//Messungen//
int temp1 = 0;  //Temp1 (Kopf) Nullen
OneWire oneWire(ONE_WIRE_BUS);  // Setup a oneWire instance to communicate with any OneWire devices (not just Maxim/Dallas temperature ICs)
DallasTemperature sensors(&oneWire);  // Pass our oneWire reference to Dallas Temperature.

DeviceAddress kopfTemp = { 0x28, 0x53, 0x6E, 0x56, 0xB5, 0x01, 0x3C, 0x5B };
/////////////





/*##########################_SETUP_################################*/
void setup() {
Serial.begin(115200);         // braucht man nicht (fuer seriellen Monitor, Kontrollausgabe)

//Deklarationen Menü "Settings"//
//  digitalWrite (PINA, HIGH);     // enable pull-ups (nur wenn keine auf Platine)
//  digitalWrite (PINB, HIGH); 
//  digitalWrite (PUSHP, HIGH); 
  attachInterrupt (INTERRUPT, isr, CHANGE);   // interrupt 0 is pin 2
  attachInterrupt (INTERRUPTB, isrp, FALLING);   // interrupt 5 is pin 18

//Laden der letzten gespeicherten Werte aus dem EEPROM
  
  //-Backlight-//
  valBacklight= EEPROM.read(addressBacklight);  // Letzte Speicherung Backlight auf Speicherplatz 16 lesen
  valBacklightnew= valBacklight;  // Variablen gleichsetzen wegen Vergleich in LOOP
  valBrightness= EEPROM.read(addressBrightness);


  //-Brightness-//
  

  
  //-Quick-Shifter-//
  activeRpm=EEPROM.read(addressactiveRpm);
  setactiveRpm=activeRpm;  
  
  delayTime=EEPROM.read(addressDelayTime);
  setDelayTime=delayTime;
  
  cutOff=EEPROM.read(addressCutOff);
  setCutOff=cutOff;  
  
  //-PowerValve-//
  open50Rpm=EEPROM.read(addressOpen50Rpm);  // PowerValve Drehzahl 50% auf
  setOpen50Rpm=open50Rpm;
  openRpm=EEPROM.read(addressOpenRpm);    // PowerValve Drezahl 100% auf
  setOpenRpm=openRpm;

  closeAngle=EEPROM.read(addressCloseAngle);   // PowerValve Winkel "zu"
  setCloseAngle=closeAngle;

  openAngle=EEPROM.read(addressOpenAngle);   // PowerValve Winkel "auf"
  setOpenAngle=openAngle;


//SERVO-Init//
 pvservo.attach(5); // Servo Signal an Pin D5 ausgeben
  pvservo.write(openAngle); // auf
  delay(700);
  pvservo.write(closeAngle); // zu
  delay(700);
////////




//Display//
  u8g2.begin();

  
//Schalter+Taster//
  pinMode (btnpin, INPUT_PULLUP);   //Page Button als Eingang
  pinMode (Backlightpin, OUTPUT);   //Pin für Backlight als Ausgang
  pinMode (LEDallOnpin, OUTPUT);
  pinMode (Brightness_1, OUTPUT);
  pinMode (Brightness_2, OUTPUT);
  digitalWrite(LEDallOnpin, LOW); // alle LEDS ausschalten
  //digitalWrite(Brightness_1, HIGH);
  //digitalWrite(Brightness_2, HIGH);
  
//Messungen//
  //-Temperatur-//
  sensors.begin();
  sensors.setResolution(kopfTemp, 9); //Temp.fühler Auflösung 9,10,11,12 bit
  sensors.setWaitForConversion(false); //request temp nicht blockierend!  

  //-Spannung-//



//Datenübertragung Arduino I2C//
  Wire.begin (MY_ADDRESS);
  Wire.onReceive (receiveEvent);


//Startup//
  startup();  //Start-Sequenz aufrufen



}//ENDE Setup

//Variablenübergabe der Werte aus dem Arduino Nano//
volatile boolean haveData = false;
volatile float frequency;
//volatile long foo;

/*##########################_LOOP_#################################*/
void loop() {

//DEBUGG//
//Serial.print("submenu:");
//Serial.println(submenu);
Serial.print("openAngle:");
Serial.println(openAngle);
Serial.print("closeAngle:");
Serial.println(closeAngle);
Serial.print("pvOpen:");
Serial.println(pvOpen);





/*------------Backlight EIN/AUS + Wert in EEPROM aktualisieren------------------*/
if (valBacklight == 1) {    // Wenn Varibale 1, Pin auf HIGH
    digitalWrite(Backlightpin, HIGH); // Backlight an Pin 38 einschalten
    }
else if (valBacklight == 0) {   // Andernfalls wenn Variable 0, Pin auf LOW
    digitalWrite(Backlightpin, LOW);  // Backlight an Pin 38 ausschalten
    }
  
    if (valBacklightnew != valBacklight) {    // Nur wenn Veränderung der Variablen
       EEPROM.write(addressBacklight, valBacklightnew); // Schreibe neuen Wert der Variable auf Speicherplatz 16
       valBacklight = EEPROM.read(addressBacklight);  // Setzte beide Variablen gleich mit Kontrolle durch Lesen aus EEPROM
     }
/*
if (activeRpm != activeRpmNew){   // Nur wenn Veränderung der Variablen
      EEPROM.write(addressactiveRpm, activeRpmNew); // Schreibe neuen Wert der Variable auf Speicherplatz 32
      activeRpm = EEPROM.read(addressactiveRpm);  // Setzte beide Variablen gleich mit Kontrolle durch Lesen aus EEPROM
    }
*/

/*-------------Eingestellte Helligkeit der LEDs an Nano weitergeben-------------------*/

if (valBrightness == 25) 
    {
    digitalWrite(Brightness_1, LOW);
    digitalWrite(Brightness_2, HIGH);
    }
else if (valBrightness == 50) 
    {
    digitalWrite(Brightness_1, HIGH);
    digitalWrite(Brightness_2, LOW);
    }
else if (valBrightness == 75) 
    {
    digitalWrite(Brightness_1, LOW);
    digitalWrite(Brightness_2, LOW);
    }
else if (valBrightness == 100) 
    {
    digitalWrite(Brightness_1, HIGH);
    digitalWrite(Brightness_2, HIGH);
    }

/*----------Datenübertragung Mega/Nano--------------------*/
 if (haveData)
    {
//    Serial.print ("Received rpm = ");
//    Serial.println (frequency);
    //Serial.print ("Received foo = ");
    //Serial.println (foo);
    haveData = false;
    }  // end if haveData


/*------------------------Display_Menü------------------------------*/


  button = !digitalRead(btnpin); // Taster einlesen und invertieren

  // Seitenumschaltung
  if (button == true && buttonflag == false) { // Pos. Flanke erkennen
    delay(10);        // Taster entprellen
    buttonflag = true;//  Status setzen
    seite++;
    if (seite > maxseite) seite = 1; // auf Anfang
  }
  // Wenn der Taster nicht gedrückt ist dann das Hiflsflag zurück
  if (button == false) buttonflag = false;

    // Auswertung der aktuellen Seite
    if (seite == 1) {
      //Serial.println("Seite 1 angewählt");
      setPage1();
      counter=0;
      submenu=0;
      digitalWrite(LEDallOnpin, LOW); // alle LEDS ausschalten
        }
     else if (seite == 2) {
      //Serial.println("Seite 2 angewählt");
      setPage2();
        }
     else if (seite == 3) {
      //Serial.println("Seite 3 angewählt");
      setPage3();
        }
     else if (seite == 4){
       setPageSettings();
              }

/*--------------SERVO----------------------------*/

middleAngle=((closeAngle)-(openAngle)/2);    // Berechnen der Stellung zwischen Auf und Zu

if (frequency <= (open50Rpm * 100)){ // unter diesem Wert bleibt der Auslassschieber geschlossen
        //digitalWrite(LED_PIN,LOW);
        //tone (CONTROL_PIN, 500); 
        pvservo.write(closeAngle);
        pvOpen50=false;
        pvOpen=false;
      }
    if (frequency >= (open50Rpm * 100) && frequency <= (openRpm * 100)){ // über diesem Wert öffnet der Auslassschieber 50%
        //digitalWrite(LED_PIN,HIGH);
        //tone (CONTROL_PIN, 1000); 
         pvservo.write(middleAngle);
         pvOpen50=true;
         pvOpen=false;
      }

    if (frequency >= (openRpm * 100)){ // über diesem Wert öffnet der Auslassschieber 100%
        //digitalWrite(LED_PIN,HIGH);
        //tone (CONTROL_PIN, 1000); 
         pvservo.write(openAngle);
         pvOpen50=false;
         pvOpen=true;
      }

/*--------------Quick-Shifter------------------*/




              
           }//ENDE LOOP
  


  
  
  


/*#####################_Daten_Empfang_Interrupt_##########################*/

//called by interrupt service routine when incoming data arrives
void receiveEvent (int howMany)
 {
 if (howMany >= (sizeof frequency)) //+ (sizeof frequency))
   {
   I2C_readAnything (frequency);
   //I2C_readAnything (foo);
   haveData = true;
   }  // end if have enough data
 }  // end of receiveEvent

//***************************END of PROGRAM******************************************;
