/*
  .d8888.  .o88b. db   db  .d8b.  db      d888888b d8888b. db      d888888b d888888b d88888D
  88'  YP d8P  Y8 88   88 d8' `8b 88      `~~88~~' 88  `8D 88        `88'   `~~88~~' YP  d8'
  `8bo.   8P      88ooo88 88ooo88 88         88    88oooY' 88         88       88       d8'
  `Y8b. 8b      88~~~88 88~~~88 88         88    88~~~b. 88         88       88      d8'
  db   8D Y8b  d8 88   88 88   88 88booo.    88    88   8D 88booo.   .88.      88     d8' db
  `8888Y'  `Y88P' YP   YP YP   YP Y88888P    YP    Y8888P' Y88888P Y888888P    YP    d88888P

  |**********************************************************************;
  Project           : Schaltblitz Aprilia RS 125 

  Program name      : Schaltblitz_Aprilia_Sender_V1.3

  Author            : el bodo es loco / 4PR1L14

  Date created      : 20200422

  Modified by       : JimmyRR

  Revision History  : Auf 23 Neopixel und entspr. Drehzahlschwellen erweitert, nur outIn2Mode für 23 LEDs!, 
                      Sendefunktion um Drehzahlwert per I2C an anderen Arduino zu senden, 
                      LED Helligkeit über 3 DIP Schalter einstellbar (50, 100, 150, 255),
                      Startup Sequenz in separatem Tab,

  Date modifiied    Vers.   Revision Date
  20210416          1.3     20210416

  |**********************************************************************;
*/
//Schaltblitz//
#include <Adafruit_NeoPixel.h>
#include <FreqMeasure.h>
#ifdef __AVR__
#include <avr/power.h>
#endif


#include <Wire.h>   // Daten Senden
#include <I2C_Anything.h> // Daten Senden

#define NUMPIXELS 23     // Anzahl an Pixel (LEDs)
#define PIN 11        // Neopixel PIN
#define PMS_PIN 8     // Drehzahlsignal-Eingang bei Rotax 122  Lima: 100Hz/1000rpm; Pickup: 16.666 Hz/1000rpm


/*----------------------------------------------------------------*/
//Funktionsprototypen (bekannt machen der unten aufgeführten Funktionen)
void blinkDelay();
void errorPrint();
void inOutMode();
void outInMode();
void leftToRightMode();
void allAllColors();
void simpleAll();
void inOutModeL2();
void leftToRightModeL2();
void rainbow();
void outIn2Mode();
void startup();
/*-----------------------------------------------------------------*/
//Neopixel-Konfiguration
Adafruit_NeoPixel pixels = Adafruit_NeoPixel(NUMPIXELS, PIN, NEO_GRB + NEO_KHZ800);

/*--------------------FARBEN---------------------------------------*/
//Farbkonfiguration                 // <--- ### HIER FARBEN UND HELLIGKEIT EINSTELLEN ###
uint32_t green    = pixels.Color(0, 100, 0);    //1. Wert rot, 2. Wert gruen, 1. Wert blau - Helligkeit von 0 (dunkel) bis 255 (hell)
uint32_t yellow   = pixels.Color(100, 100, 0);
uint32_t orange   = pixels.Color(200, 100, 0);
uint32_t red      = pixels.Color(100, 0, 0);
uint32_t white    = pixels.Color(100, 100, 100);
uint32_t blue     = pixels.Color(0, 0, 100);
uint32_t black    = pixels.Color(0, 0, 0);
uint32_t violet   = pixels.Color(68, 50, 127);
uint32_t darkblue   = pixels.Color(0, 0, 68);
uint32_t lightblue  = pixels.Color(0, 68, 127);

/*--------------------SCHALTBLITZ-MODI-----------------------------*/
enum Modes {inOut = 0, outIn, outIn2, left2Right, allAll, simple, inOutL2, left2RightL2, rainb};
const int lightMODE = outIn2;      // <--- ### HIER MODUS EINSTELLEN (entweder nach Name z. B. "inOut" oder per Zahl z. B. "0" -> von 0 bis 7 möglich ["7" entspricht "rainb"]) ###
//const int lightMODE = 0;        // alternativ zur vorherigen Zeile

/*--------------------DREHZAHL-------------------------------------*/
//Motorrad-/Drehzahl-Paramteter
struct bikeParameters {
  float min_revs = 0.;      // Minimalwert (um Fehler auszuschließen)
  float max_revs = 14000.;  // Maximalwert (um Fehler auszuschließen)
  //(Drehzahlschwellen - genutzt fuer Funktion: inOutMode(), OutinMode(), allAllColors(), simpleAll(), inOutModeL2())
  float threshold_0 = threshold_1 - 1,
        threshold_1 = 5000.,
        threshold_2 = 6000.,
        threshold_3 = 7000.,
        threshold_4 = 8000.,
        threshold_5 = 8500.,
        threshold_6 = 9000.,
        threshold_7 = 9500.,
        threshold_8 = 10000.,
        threshold_9 = 10500.,
        threshold_10 = 11000.,
        threshold_11 = 11250.,
        threshold_12 = 11500.;  // <--- ### HIER DREHZAHL EINSTELLEN ###
  //(Drehzahlschwellen - genutzt fuer Funktion: leftToRightMode(), leftToRightModeL2(), rainbow())
  float threshold_lr0 = threshold_lr1 - 1,
        threshold_lr1 = 5000.,
        threshold_lr2 = 6000.,
        threshold_lr3 = 6250.,
        threshold_lr4 = 6500.,
        threshold_lr5 = 6750.,
        threshold_lr6 = 7000.,
        threshold_lr7 = 7250.,
        threshold_lr8 = 7500.,
        threshold_lr9 = 7750.,
        threshold_lr10 = 8000.,
        threshold_lr11 = 8250.,
        threshold_lr12 = 8500.,
        threshold_lr13 = 8750.,
        threshold_lr14 = 9000.,
        threshold_lr15 = 9250.,
        threshold_lr16 = 9500.,
        threshold_lr17 = 9750.,
        threshold_lr18 = 10000.,
        threshold_lr19 = 10250.,
        threshold_lr20 = 10500.,
        threshold_lr21 = 10750.,
        threshold_lr22 = 11000.,
        threshold_lr23 = 11250.,
        threshold_lr24 = 11500.;
} RS125;

/*--------------------VARIABLEN---------------------------------------*/
unsigned long data_unavailable = 0;
unsigned long data_available = 0;
const long interval = 1000;
int blink_interval = 30;        // Blinkintervall des Schaltblitzes <--- ### HIER INTERVALL EINSTELLEN ###
double sum = 0;
int count = 0;
int total_counts = 10;          // Anzahl Messungen, bevor der Mittelwert ausgerechnet wird <--- ### HIER ANZAHL EINSTELLEN ### (standard = 30)
float frequency = 0.;

const byte SLAVE_ADDRESS = 42;  // Daten Senden: Adresse des Empfängers

int LED_test = 2;          // Pin um alle LEDs einzuschalten
int brightness_1 = 3;     // Pin um Helligkeit 1 zu regulieren
int brightness_2 = 4;     // Pin um Helligkeit 2 zu regulieren

/*##########################_SETUP_################################*/
void setup() {

#if defined (__AVR_ATtiny85__)
  if (F_CPU == 16000000) clock_prescale_set(clock_div_1); // Frequenz des Mikrocontrollers
#endif

  pixels.begin();             // Initialisiere NEOPIXEL.
  pixels.show();

  pinMode (PMS_PIN, INPUT_PULLUP);  // Pullup muss hier stehen
  pinMode (LED_test, INPUT_PULLUP); // Alle LEDs Ein
  pinMode (brightness_1, INPUT_PULLUP); // Helligkeit Einstellen 1
  pinMode (brightness_2, INPUT_PULLUP); // Helligkeit Einstellen 2

  
  Serial.begin(9600);         // braucht man nicht (fuer seriellen Monitor, Kontrollausgabe)
  FreqMeasure.begin();

  Wire.begin ();

  startup();    // Startup Sequenz abspielen


}
/*##########################_LOOP_#################################*/
void loop() {

//////////////////////_Einstellung Helligkeit_/////////////////////
 
  if (digitalRead(brightness_1) == LOW){    //Pin 3 auf GND = Helligkeit 50 (Später in Setup!)
        pixels.setBrightness(50);
     if((digitalRead(brightness_1) == LOW) && (digitalRead(brightness_2) == LOW)){    //Pin 3+4 auf GND = Helligkeit 150 (Später in Setup!)
          pixels.setBrightness(150);}}
 
      else if (digitalRead(brightness_2) == LOW){   //Pin 4 auf GND = Helligkeit 100 (Später in Setup!)
          pixels.setBrightness(100);}
  
      else if((digitalRead(brightness_1) == HIGH) && (digitalRead(brightness_2) == HIGH)){    //
          pixels.setBrightness(255);}
          
    if (digitalRead(LED_test) == HIGH){        //Pin 2 auf HIGH = Alle LEDs Einschalten, zur Helligkeitseinstellung
    pixels.setPixelColor(0, green);
    pixels.setPixelColor(1, green);
    pixels.setPixelColor(2, green);
    pixels.setPixelColor(3, yellow);
    pixels.setPixelColor(4, yellow);
    pixels.setPixelColor(5, yellow);
    pixels.setPixelColor(6, orange);
    pixels.setPixelColor(7, orange);
    pixels.setPixelColor(8, orange);
    pixels.setPixelColor(9, orange);
    pixels.setPixelColor(10, red);
    pixels.setPixelColor(11, red);
    pixels.setPixelColor(12, red);
    pixels.setPixelColor(13, orange);
    pixels.setPixelColor(14, orange);
    pixels.setPixelColor(15, orange);
    pixels.setPixelColor(16, orange);
    pixels.setPixelColor(17, yellow);
    pixels.setPixelColor(18, yellow);
    pixels.setPixelColor(19, yellow);
    pixels.setPixelColor(20, green);
    pixels.setPixelColor(21, green);
    pixels.setPixelColor(22, green);
    pixels.show();
    }

////////////////////////////////////////////////////////////////////////////

  if (FreqMeasure.available()) {
    sum = sum + FreqMeasure.read();
    count = count + 1;
    if (count > total_counts) {   // Anzahl Messungen erreicht
      frequency = FreqMeasure.countToFrequency(sum / count); // berechne Mittelwert
      frequency = frequency * 60; // rpm

    //  Serial.print("Rpm=");
    //  Serial.println(frequency);
      
//Daten Senden//
      Wire.beginTransmission (SLAVE_ADDRESS); // Beginne Daten zu Senden
      I2C_writeAnything (frequency);          // Sende Wert der Variable
      Wire.endTransmission ();                // Beende Daten zu Senden
///////////////   
      
      data_available = millis();  // Zeitpunkt zu dem Daten zur Verfuegung standen
      sum = 0;
      count = 0;

      if (frequency < RS125.min_revs || frequency >  RS125.max_revs) { //Sicherheitsabfrage, ob rpm innerhalb min<->max
       // Serial.println("Error, frequency out of range or no signal available.");
       // Serial.println(frequency);
        pixels.clear();
        pixels.show();
        frequency = 0.;
      }
      /*else{
        if (frequency < RS125.threshold_1 || frequency < RS125.threshold_lr1) {   // wenn Drehzahl zu niedrieg, alle Pixel aus
          pixels.clear();
          pixels.show();
        }*/
      else {                          // sonst weitermachen
        switch (lightMODE) {              // jeweilige Code-Ausfuehrung, je nach gewaehltem Modus
          case 0: inOutMode();      break;  // gehe zur Funktion "inOutMode()" und setze entsprechende Pixel, je nach Drehzahl
          case 1: outInMode();      break;
          case 2: outIn2Mode();      break;
          case 3: leftToRightMode();  break;
          case 4: allAllColors();     break;
          case 5: simpleAll();      break;
          case 6: inOutModeL2();    break;
          case 7: leftToRightModeL2();  break;
          case 8: rainbow();      break;
          default: Serial.println("Mode error!"); break;
        }
        pixels.show();// gesetzte Pixel ausgeben, nach der fertigen/nach dem Verlassen der Funktion
 //     }
    }
  }
 }
  else {              // Logik um bei Signalausfall alles auf 0 zu setzen
    data_unavailable = millis();  // Zeitpunkt zu dem keine Daten mehr zur Verfuegung standen

    if (data_unavailable - data_available >= interval) { // wenn seit dem letzten Datenverlust mehr als ein Intervall (1 Sek. [1000 millis]) vergangen ist, alles ausschalten
      Serial.print ("Rpm=");
      Serial.println("0");

      frequency = 0.;
      
      //Daten Senden//
      Wire.beginTransmission (SLAVE_ADDRESS); // Beginne Daten zu Senden
      I2C_writeAnything (frequency);          // Sende Wert der Variable
      Wire.endTransmission ();                // Beende Daten zu Senden
      ///////////////   
      
      pixels.clear();
      pixels.show();
    }
  }
}
/*+++++++++++++++++++BLINK DELAY++++++++++++++++++++++++++++++++++++*/
void blinkDelay() {   // Pixel blinken lassen

  pixels.show();
  delay(blink_interval);
  pixels.clear();
  pixels.show();
  delay(blink_interval);
}
/*+++++++++++++++++++ERROR PRINT++++++++++++++++++++++++++++++++++++*/
void errorPrint() {   // etwas schief gelaufen

  Serial.print ("Error!\n");
}
/*+++++++++++++++++++inOut MODE+++++++++++++++++++++++++++++++++++++*/
void inOutMode() {

  if (frequency >= RS125.threshold_1 && frequency < RS125.threshold_2) {      // gruen
    for (int i = 3; i < 5; i++) {
      pixels.setPixelColor(i, green); // setze Pixel 3 und 4 auf gruen
    }
    for (int i = 0; i < 3; i++) {
      pixels.setPixelColor(i, black); // restliche Pixel aus
    }
    for (int i = 5; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_2 && frequency < RS125.threshold_3) {   // gelb
    for (int i = 2; i < 6; i++) {
      pixels.setPixelColor(i, yellow); // setze Pixel 2 bis 5 auf gelb
    }
    for (int i = 0; i < 2; i++) {
      pixels.setPixelColor(i, black); // restliche Pixel aus
    }
    for (int i = 6; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_3 && frequency < RS125.threshold_4) {   // orange
    for (int i = 1; i < 7; i++) {
      pixels.setPixelColor(i, orange); // setze Pixel 1 bis 6 auf orange
    }
    pixels.setPixelColor(0, black); pixels.setPixelColor(7, black);
  }
  else if (frequency >= RS125.threshold_4 && frequency < RS125.threshold_5) {   // rot
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, red); // setze Pixel 0 bis 7 auf rot (alle 8)
    }
  }
  else if (frequency >= RS125.threshold_5 && frequency <= RS125.max_revs) {   // rot blinkend, ab/ueber diesem Wert geht das Schaltlicht an
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, red); // setze Pixel 0 bis 7 auf rot (alle 8)
    }
    blinkDelay(); // rufe Funktion zum Blinken auf
  }
  else if (frequency >= RS125.threshold_0 && frequency <= RS125.max_revs) {   // unterhalb der Warnschwelle bleiben alle lichter Schwarz geschalten
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black); // setze Pixel 0 bis 7 auf schwarz (alle 8)
    }
  }
  else {      // Sicherheitsabfrage
    errorPrint();
  }
}
/*+++++++++++++++++++outIn MODE+++++++++++++++++++++++++++++++++++++*/
void outInMode() {

  if (frequency >= RS125.min_revs && frequency < RS125.threshold_1) {
    pixels.setPixelColor(0, green);
    pixels.setPixelColor(22, green);
    for (int i = 1; i < 22; i++) {
      pixels.setPixelColor(i, black);
    }
  }

  else if (frequency >= RS125.threshold_1 && frequency < RS125.threshold_2) {
    pixels.setPixelColor(0, green);
    pixels.setPixelColor(1, green);
    pixels.setPixelColor(21, green);
    pixels.setPixelColor(22, green);
    for (int i = 2; i < 21; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_2 && frequency < RS125.threshold_3) {
    pixels.setPixelColor(0, green);
    pixels.setPixelColor(1, green);
    pixels.setPixelColor(2, green);
    pixels.setPixelColor(20, green);
    pixels.setPixelColor(21, green);
    pixels.setPixelColor(22, green);
    for (int i = 3; i < 20; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_3 && frequency < RS125.threshold_4) {
    pixels.setPixelColor(0, green);
    pixels.setPixelColor(1, green);
    pixels.setPixelColor(2, green);
    pixels.setPixelColor(3, yellow);
    pixels.setPixelColor(19, yellow);
    pixels.setPixelColor(20, green);
    pixels.setPixelColor(21, green);
    pixels.setPixelColor(22, green);
    for (int i = 4; i < 19; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_4 && frequency < RS125.threshold_5) {
    pixels.setPixelColor(0, green);
    pixels.setPixelColor(1, green);
    pixels.setPixelColor(2, green);
    pixels.setPixelColor(3, yellow);
    pixels.setPixelColor(4, yellow);
    pixels.setPixelColor(18, yellow);
    pixels.setPixelColor(19, yellow);
    pixels.setPixelColor(20, green);
    pixels.setPixelColor(21, green);
    pixels.setPixelColor(22, green);
    for (int i = 5; i < 18; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_5 && frequency < RS125.threshold_6) {
    pixels.setPixelColor(0, green);
    pixels.setPixelColor(1, green);
    pixels.setPixelColor(2, green);
    pixels.setPixelColor(3, yellow);
    pixels.setPixelColor(4, yellow);
    pixels.setPixelColor(5, yellow);
    pixels.setPixelColor(17, yellow);
    pixels.setPixelColor(18, yellow);
    pixels.setPixelColor(19, yellow);
    pixels.setPixelColor(20, green);
    pixels.setPixelColor(21, green);
    pixels.setPixelColor(22, green);
    for (int i = 6; i < 17; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_6 && frequency < RS125.threshold_7) {
    pixels.setPixelColor(0, green);
    pixels.setPixelColor(1, green);
    pixels.setPixelColor(2, green);
    pixels.setPixelColor(3, yellow);
    pixels.setPixelColor(4, yellow);
    pixels.setPixelColor(5, yellow);
    pixels.setPixelColor(6, orange);
    pixels.setPixelColor(16, orange);
    pixels.setPixelColor(17, yellow);
    pixels.setPixelColor(18, yellow);
    pixels.setPixelColor(19, yellow);
    pixels.setPixelColor(20, green);
    pixels.setPixelColor(21, green);
    pixels.setPixelColor(22, green);
    for (int i = 7; i < 16; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_7 && frequency < RS125.threshold_8) {
    pixels.setPixelColor(0, green);
    pixels.setPixelColor(1, green);
    pixels.setPixelColor(2, green);
    pixels.setPixelColor(3, yellow);
    pixels.setPixelColor(4, yellow);
    pixels.setPixelColor(5, yellow);
    pixels.setPixelColor(6, orange);
    pixels.setPixelColor(7, orange);
    pixels.setPixelColor(15, orange);
    pixels.setPixelColor(16, orange);
    pixels.setPixelColor(17, yellow);
    pixels.setPixelColor(18, yellow);
    pixels.setPixelColor(19, yellow);
    pixels.setPixelColor(20, green);
    pixels.setPixelColor(21, green);
    pixels.setPixelColor(22, green);
    for (int i = 8; i < 15; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_8 && frequency < RS125.threshold_9) {
    pixels.setPixelColor(0, green);
    pixels.setPixelColor(1, green);
    pixels.setPixelColor(2, green);
    pixels.setPixelColor(3, yellow);
    pixels.setPixelColor(4, yellow);
    pixels.setPixelColor(5, yellow);
    pixels.setPixelColor(6, orange);
    pixels.setPixelColor(7, orange);
    pixels.setPixelColor(8, orange);
    pixels.setPixelColor(14, orange);
    pixels.setPixelColor(15, orange);
    pixels.setPixelColor(16, orange);
    pixels.setPixelColor(17, yellow);
    pixels.setPixelColor(18, yellow);
    pixels.setPixelColor(19, yellow);
    pixels.setPixelColor(20, green);
    pixels.setPixelColor(21, green);
    pixels.setPixelColor(22, green);
    for (int i = 9; i < 14; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_9 && frequency < RS125.threshold_10) {
    pixels.setPixelColor(0, green);
    pixels.setPixelColor(1, green);
    pixels.setPixelColor(2, green);
    pixels.setPixelColor(3, yellow);
    pixels.setPixelColor(4, yellow);
    pixels.setPixelColor(5, yellow);
    pixels.setPixelColor(6, orange);
    pixels.setPixelColor(7, orange);
    pixels.setPixelColor(8, orange);
    pixels.setPixelColor(9, orange);
    pixels.setPixelColor(13, orange);
    pixels.setPixelColor(14, orange);
    pixels.setPixelColor(15, orange);
    pixels.setPixelColor(16, orange);
    pixels.setPixelColor(17, yellow);
    pixels.setPixelColor(18, yellow);
    pixels.setPixelColor(19, yellow);
    pixels.setPixelColor(20, green);
    pixels.setPixelColor(21, green);
    pixels.setPixelColor(22, green);
    for (int i = 10; i < 13; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_10 && frequency < RS125.threshold_11) {
    pixels.setPixelColor(0, green);
    pixels.setPixelColor(1, green);
    pixels.setPixelColor(2, green);
    pixels.setPixelColor(3, yellow);
    pixels.setPixelColor(4, yellow);
    pixels.setPixelColor(5, yellow);
    pixels.setPixelColor(6, orange);
    pixels.setPixelColor(7, orange);
    pixels.setPixelColor(8, orange);
    pixels.setPixelColor(9, orange);
    pixels.setPixelColor(10, red);
    pixels.setPixelColor(12, red);
    pixels.setPixelColor(13, orange);
    pixels.setPixelColor(14, orange);
    pixels.setPixelColor(15, orange);
    pixels.setPixelColor(16, orange);
    pixels.setPixelColor(17, yellow);
    pixels.setPixelColor(18, yellow);
    pixels.setPixelColor(19, yellow);
    pixels.setPixelColor(20, green);
    pixels.setPixelColor(21, green);
    pixels.setPixelColor(22, green);
    for (int i = 11; i < 12; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_11 && frequency < RS125.threshold_12) {
    pixels.setPixelColor(0, green);
    pixels.setPixelColor(1, green);
    pixels.setPixelColor(2, green);
    pixels.setPixelColor(3, yellow);
    pixels.setPixelColor(4, yellow);
    pixels.setPixelColor(5, yellow);
    pixels.setPixelColor(6, orange);
    pixels.setPixelColor(7, orange);
    pixels.setPixelColor(8, orange);
    pixels.setPixelColor(9, orange);
    pixels.setPixelColor(10, red);
    pixels.setPixelColor(11, red);
    pixels.setPixelColor(12, red);
    pixels.setPixelColor(13, orange);
    pixels.setPixelColor(14, orange);
    pixels.setPixelColor(15, orange);
    pixels.setPixelColor(16, orange);
    pixels.setPixelColor(17, yellow);
    pixels.setPixelColor(18, yellow);
    pixels.setPixelColor(19, yellow);
    pixels.setPixelColor(20, green);
    pixels.setPixelColor(21, green);
    pixels.setPixelColor(22, green);
    // for (int i = 10; i < 13; i++) {pixels.setPixelColor(i, black);}
  }
  else if (frequency >= RS125.threshold_12 && frequency <= RS125.max_revs) {
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, red);
    }
    blinkDelay();
  }
  else if (frequency >= RS125.threshold_0 && frequency <= RS125.max_revs) {   // unterhalb der Warnschwelle bleiben alle lichter Schwarz geschalten
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black); // setze Pixel 0 bis 7 auf schwarz (alle 8)
    }
  }
  else {
    errorPrint();
  }
}

/*+++++++++++++++++++outIn2 MODE+++++++++++++++++++++++++++++++++++++*/
void outIn2Mode() {

  if (frequency >= RS125.min_revs && frequency < RS125.threshold_1) {
    pixels.setPixelColor(0, darkblue);
    pixels.setPixelColor(22, darkblue);
    for (int i = 1; i < 22; i++) {
      pixels.setPixelColor(i, black);
    }
  }

  else if (frequency >= RS125.threshold_1 && frequency < RS125.threshold_2) {
    pixels.setPixelColor(0, black);
    pixels.setPixelColor(1, green);
    pixels.setPixelColor(21, green);
    pixels.setPixelColor(22, black);
    for (int i = 2; i < 21; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_2 && frequency < RS125.threshold_3) {
    pixels.setPixelColor(0, black);
    pixels.setPixelColor(1, green);
    pixels.setPixelColor(2, green);
    pixels.setPixelColor(20, green);
    pixels.setPixelColor(21, green);
    pixels.setPixelColor(22, black);
    for (int i = 3; i < 20; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_3 && frequency < RS125.threshold_4) {
    pixels.setPixelColor(0, black);
    pixels.setPixelColor(1, black);
    pixels.setPixelColor(2, green);
    pixels.setPixelColor(3, yellow);
    pixels.setPixelColor(19, yellow);
    pixels.setPixelColor(20, green);
    pixels.setPixelColor(21, black);
    pixels.setPixelColor(22, black);
    for (int i = 4; i < 19; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_4 && frequency < RS125.threshold_5) {
    pixels.setPixelColor(0, black);
    pixels.setPixelColor(1, black);
    pixels.setPixelColor(2, black);
    pixels.setPixelColor(3, yellow);
    pixels.setPixelColor(4, yellow);
    pixels.setPixelColor(18, yellow);
    pixels.setPixelColor(19, yellow);
    pixels.setPixelColor(20, black);
    pixels.setPixelColor(21, black);
    pixels.setPixelColor(22, black);
    for (int i = 5; i < 18; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_5 && frequency < RS125.threshold_6) {
    pixels.setPixelColor(0, black);
    pixels.setPixelColor(1, black);
    pixels.setPixelColor(2, black);
    pixels.setPixelColor(3, black);
    pixels.setPixelColor(4, yellow);
    pixels.setPixelColor(5, yellow);
    pixels.setPixelColor(17, yellow);
    pixels.setPixelColor(18, yellow);
    pixels.setPixelColor(19, black);
    pixels.setPixelColor(20, black);
    pixels.setPixelColor(21, black);
    pixels.setPixelColor(22, black);
    for (int i = 6; i < 17; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_6 && frequency < RS125.threshold_7) {
    pixels.setPixelColor(0, black);
    pixels.setPixelColor(1, black);
    pixels.setPixelColor(2, black);
    pixels.setPixelColor(3, black);
    pixels.setPixelColor(4, black);
    pixels.setPixelColor(5, yellow);
    pixels.setPixelColor(6, orange);
    pixels.setPixelColor(16, orange);
    pixels.setPixelColor(17, yellow);
    pixels.setPixelColor(18, black);
    pixels.setPixelColor(19, black);
    pixels.setPixelColor(20, black);
    pixels.setPixelColor(21, black);
    pixels.setPixelColor(22, black);
    for (int i = 7; i < 16; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_7 && frequency < RS125.threshold_8) {
    pixels.setPixelColor(0, black);
    pixels.setPixelColor(1, black);
    pixels.setPixelColor(2, black);
    pixels.setPixelColor(3, black);
    pixels.setPixelColor(4, black);
    pixels.setPixelColor(5, black);
    pixels.setPixelColor(6, orange);
    pixels.setPixelColor(7, orange);
    pixels.setPixelColor(15, orange);
    pixels.setPixelColor(16, orange);
    pixels.setPixelColor(17, black);
    pixels.setPixelColor(18, black);
    pixels.setPixelColor(19, black);
    pixels.setPixelColor(20, black);
    pixels.setPixelColor(21, black);
    pixels.setPixelColor(22, black);
    for (int i = 8; i < 15; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_8 && frequency < RS125.threshold_9) {
    pixels.setPixelColor(0, black);
    pixels.setPixelColor(1, black);
    pixels.setPixelColor(2, black);
    pixels.setPixelColor(3, black);
    pixels.setPixelColor(4, black);
    pixels.setPixelColor(5, black);
    pixels.setPixelColor(6, black);
    pixels.setPixelColor(7, orange);
    pixels.setPixelColor(8, orange);
    pixels.setPixelColor(14, orange);
    pixels.setPixelColor(15, orange);
    pixels.setPixelColor(16, black);
    pixels.setPixelColor(17, black);
    pixels.setPixelColor(18, black);
    pixels.setPixelColor(19, black);
    pixels.setPixelColor(20, black);
    pixels.setPixelColor(21, black);
    pixels.setPixelColor(22, black);
    for (int i = 9; i < 14; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_9 && frequency < RS125.threshold_10) {
    pixels.setPixelColor(0, black);
    pixels.setPixelColor(1, black);
    pixels.setPixelColor(2, black);
    pixels.setPixelColor(3, black);
    pixels.setPixelColor(4, black);
    pixels.setPixelColor(5, black);
    pixels.setPixelColor(6, black);
    pixels.setPixelColor(7, black);
    pixels.setPixelColor(8, orange);
    pixels.setPixelColor(9, orange);
    pixels.setPixelColor(13, orange);
    pixels.setPixelColor(14, orange);
    pixels.setPixelColor(15, black);
    pixels.setPixelColor(16, black);
    pixels.setPixelColor(17, black);
    pixels.setPixelColor(18, black);
    pixels.setPixelColor(19, black);
    pixels.setPixelColor(20, black);
    pixels.setPixelColor(21, black);
    pixels.setPixelColor(22, black);
    for (int i = 10; i < 13; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_10 && frequency < RS125.threshold_11) {
    pixels.setPixelColor(0, black);
    pixels.setPixelColor(1, black);
    pixels.setPixelColor(2, black);
    pixels.setPixelColor(3, black);
    pixels.setPixelColor(4, black);
    pixels.setPixelColor(5, black);
    pixels.setPixelColor(6, black);
    pixels.setPixelColor(7, black);
    pixels.setPixelColor(8, black);
    pixels.setPixelColor(9, orange);
    pixels.setPixelColor(10, red);
    pixels.setPixelColor(12, red);
    pixels.setPixelColor(13, orange);
    pixels.setPixelColor(14, black);
    pixels.setPixelColor(15, black);
    pixels.setPixelColor(16, black);
    pixels.setPixelColor(17, black);
    pixels.setPixelColor(18, black);
    pixels.setPixelColor(19, black);
    pixels.setPixelColor(20, black);
    pixels.setPixelColor(21, black);
    pixels.setPixelColor(22, black);
    for (int i = 11; i < 12; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_11 && frequency < RS125.threshold_12) {
    pixels.setPixelColor(0, black);
    pixels.setPixelColor(1, black);
    pixels.setPixelColor(2, black);
    pixels.setPixelColor(3, black);
    pixels.setPixelColor(4, black);
    pixels.setPixelColor(5, black);
    pixels.setPixelColor(6, black);
    pixels.setPixelColor(7, black);
    pixels.setPixelColor(8, black);
    pixels.setPixelColor(9, black);
    pixels.setPixelColor(10, red);
    pixels.setPixelColor(11, red);
    pixels.setPixelColor(12, red);
    pixels.setPixelColor(13, black);
    pixels.setPixelColor(14, black);
    pixels.setPixelColor(15, black);
    pixels.setPixelColor(16, black);
    pixels.setPixelColor(17, black);
    pixels.setPixelColor(18, black);
    pixels.setPixelColor(19, black);
    pixels.setPixelColor(20, black);
    pixels.setPixelColor(21, black);
    pixels.setPixelColor(22, black);
    // for (int i = 10; i < 13; i++) {pixels.setPixelColor(i, black);}
  }
  else if (frequency >= RS125.threshold_12 && frequency <= RS125.max_revs) {
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, red);
    }
    blinkDelay();
  }
  else if (frequency >= RS125.threshold_0 && frequency <= RS125.max_revs) {   // unterhalb der Warnschwelle bleiben alle lichter Schwarz geschalten
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black); // setze Pixel 0 bis 7 auf schwarz (alle 8)
    }
  }
  else {
    errorPrint();
  }
}
/*+++++++++++++++++++leftToRight MODE+++++++++++++++++++++++++++++++++*/
void leftToRightMode() {

  if (frequency >= RS125.threshold_lr1 && frequency < RS125.threshold_lr2) {
    pixels.setPixelColor(0, green);
    for (int i = 1; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_lr2 && frequency < RS125.threshold_lr3) {
    for (int i = 0; i < 2; i++) {
      pixels.setPixelColor(i, green);
    }
    for (int i = 2; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_lr3 && frequency < RS125.threshold_lr4) {
    for (int i = 0; i < 2; i++) {
      pixels.setPixelColor(i, green);
    }
    pixels.setPixelColor(2, yellow);
    for (int i = 3; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_lr4 && frequency < RS125.threshold_lr5) {
    for (int i = 0; i < 2; i++) {
      pixels.setPixelColor(i, green);
    }
    for (int i = 2; i < 4; i++) {
      pixels.setPixelColor(i, yellow);
    }
    for (int i = 4; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_lr5 && frequency < RS125.threshold_lr6) {
    for (int i = 0; i < 2; i++) {
      pixels.setPixelColor(i, green);
    }
    for (int i = 2; i < 4; i++) {
      pixels.setPixelColor(i, yellow);
    }
    pixels.setPixelColor(4, orange);
    for (int i = 5; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_lr6 && frequency < RS125.threshold_lr7) {
    for (int i = 0; i < 2; i++) {
      pixels.setPixelColor(i, green);
    }
    for (int i = 2; i < 4; i++) {
      pixels.setPixelColor(i, yellow);
    }
    for (int i = 4; i < 6; i++) {
      pixels.setPixelColor(i, orange);
    }
    for (int i = 6; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_lr7 && frequency < RS125.threshold_lr8) {
    for (int i = 0; i < 2; i++) {
      pixels.setPixelColor(i, green);
    }
    for (int i = 2; i < 4; i++) {
      pixels.setPixelColor(i, yellow);
    }
    for (int i = 4; i < 6; i++) {
      pixels.setPixelColor(i, orange);
    }
    pixels.setPixelColor(6, red);
    pixels.setPixelColor(7, black);
  }
  else if (frequency >= RS125.threshold_lr8 && frequency < RS125.threshold_lr9) {
    for (int i = 0; i < 2; i++) {
      pixels.setPixelColor(i, green);
    }
    for (int i = 2; i < 4; i++) {
      pixels.setPixelColor(i, yellow);
    }
    for (int i = 4; i < 6; i++) {
      pixels.setPixelColor(i, orange);
    }
    for (int i = 6; i < 8; i++) {
      pixels.setPixelColor(i, red);
    }
  }
  else if (frequency >= RS125.threshold_lr9 && frequency <= RS125.max_revs) {
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, red);
    }
    blinkDelay();
  }
  else if (frequency >= RS125.threshold_lr0 && frequency <= RS125.max_revs) {   // unterhalb der Warnschwelle bleiben alle lichter Schwarz geschalten
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black); // setze Pixel 0 bis 7 auf schwarz (alle 8)
    }
  }
  else {
    errorPrint();
  }
}
/*+++++++++++++++++++allAll MODE++++++++++++++++++++++++++++++++++++*/
void allAllColors() {

  if (frequency >= RS125.threshold_1 && frequency < RS125.threshold_2) {
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, green);
    }
  }
  else if (frequency >= RS125.threshold_2 && frequency < RS125.threshold_3) {
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, yellow);
    }
  }
  else if (frequency >= RS125.threshold_3 && frequency < RS125.threshold_4) {
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, orange);
    }
  }
  else if (frequency >= RS125.threshold_4 && frequency < RS125.threshold_5) {
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, red);
    }
  }
  else if (frequency >= RS125.threshold_5 && frequency <= RS125.max_revs) {
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, red);
    }
    blinkDelay();
  }
  else if (frequency >= RS125.threshold_0 && frequency <= RS125.max_revs) {   // unterhalb der Warnschwelle bleiben alle lichter Schwarz geschalten
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black); // setze Pixel 0 bis 7 auf schwarz (alle 8)
    }
  }
  else {
    errorPrint();
  }
}
/*+++++++++++++++++++simpleAll MODE++++++++++++++++++++++++++++++++++++*/
void simpleAll() {

  if (frequency >= RS125.threshold_1 && frequency < RS125.threshold_4) {
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  if (frequency >= RS125.threshold_4 && frequency < RS125.threshold_5) {
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, white);
    }
  }
  else if (frequency >= RS125.threshold_5 && frequency <= RS125.max_revs) {
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, white);
    }
    blinkDelay();
  }
  else if (frequency >= RS125.threshold_0 && frequency <= RS125.max_revs) {   // unterhalb der Warnschwelle bleiben alle lichter Schwarz geschalten
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black); // setze Pixel 0 bis 7 auf schwarz (alle 8)
    }
  }
  else {
    errorPrint();
  }
}
/*+++++++++++++++++++inOutL2 MODE++++++++++++++++++++++++++++++++++++++*/
void inOutModeL2() {

  if (frequency >= RS125.threshold_1 && frequency < RS125.threshold_2) {
    for (int i = 3; i < 5; i++) {
      pixels.setPixelColor(i, green);
    }
    for (int i = 0; i < 3; i++) {
      pixels.setPixelColor(i, black);
    }
    for (int i = 5; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_2 && frequency < RS125.threshold_3) {
    for (int i = 3; i < 5; i++) {
      pixels.setPixelColor(i, green);
    }
    pixels.setPixelColor(2, yellow);
    pixels.setPixelColor(5, yellow);
    for (int i = 0; i < 2; i++) {
      pixels.setPixelColor(i, black);
    }
    for (int i = 6; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_3 && frequency < RS125.threshold_4) {
    for (int i = 3; i < 5; i++) {
      pixels.setPixelColor(i, green);
    }
    pixels.setPixelColor(2, yellow);
    pixels.setPixelColor(5, yellow);
    pixels.setPixelColor(1, orange);
    pixels.setPixelColor(6, orange);
    pixels.setPixelColor(0, black);
    pixels.setPixelColor(7, black);
  }
  else if (frequency >= RS125.threshold_4 && frequency < RS125.threshold_5) {
    for (int i = 3; i < 5; i++) {
      pixels.setPixelColor(i, green);
    }
    pixels.setPixelColor(2, yellow);
    pixels.setPixelColor(5, yellow);
    pixels.setPixelColor(1, orange);
    pixels.setPixelColor(6, orange);
    pixels.setPixelColor(0, red);
    pixels.setPixelColor(7, red);
  }
  else if (frequency >= RS125.threshold_5 && frequency <= RS125.max_revs) {
    for (int i = 3; i < 5; i++) {
      pixels.setPixelColor(i, green);
    }
    pixels.setPixelColor(2, yellow);
    pixels.setPixelColor(5, yellow);
    pixels.setPixelColor(1, orange);
    pixels.setPixelColor(6, orange);
    pixels.setPixelColor(0, red);
    pixels.setPixelColor(7, red);
    pixels.show();
    delay(blink_interval);
    for (int i = 3; i < 5; i++) {
      pixels.setPixelColor(i, green);
    }
    pixels.setPixelColor(2, yellow);
    pixels.setPixelColor(5, yellow);
    pixels.setPixelColor(1, orange);
    pixels.setPixelColor(6, orange);
    pixels.setPixelColor(0, black);
    pixels.setPixelColor(7, black);
    pixels.show();
    delay(blink_interval);
  }
  else if (frequency >= RS125.threshold_0 && frequency <= RS125.max_revs) {   // unterhalb der Warnschwelle bleiben alle lichter Schwarz geschalten
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black); // setze Pixel 0 bis 7 auf schwarz (alle 8)
    }
  }
  else {
    errorPrint();
  }
}
/*+++++++++++++++++++leftToRightL2 MODE+++++++++++++++++++++++++++++++++*/
void leftToRightModeL2() {

  if (frequency >= RS125.threshold_lr1 && frequency < RS125.threshold_lr2) {
    pixels.setPixelColor(0, green);
    for (int i = 1; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_lr2 && frequency < RS125.threshold_lr3) {
    for (int i = 0; i < 2; i++) {
      pixels.setPixelColor(i, green);
    }
    for (int i = 2; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_lr3 && frequency < RS125.threshold_lr4) {
    for (int i = 0; i < 2; i++) {
      pixels.setPixelColor(i, green);
    }
    pixels.setPixelColor(2, yellow);
    for (int i = 3; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_lr4 && frequency < RS125.threshold_lr5) {
    for (int i = 0; i < 2; i++) {
      pixels.setPixelColor(i, green);
    }
    for (int i = 2; i < 4; i++) {
      pixels.setPixelColor(i, yellow);
    }
    for (int i = 4; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_lr5 && frequency < RS125.threshold_lr6) {
    for (int i = 0; i < 2; i++) {
      pixels.setPixelColor(i, green);
    }
    for (int i = 2; i < 4; i++) {
      pixels.setPixelColor(i, yellow);
    }
    pixels.setPixelColor(4, orange);
    for (int i = 5; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_lr6 && frequency < RS125.threshold_lr7) {
    for (int i = 0; i < 2; i++) {
      pixels.setPixelColor(i, green);
    }
    for (int i = 2; i < 4; i++) {
      pixels.setPixelColor(i, yellow);
    }
    for (int i = 4; i < 6; i++) {
      pixels.setPixelColor(i, orange);
    }
    for (int i = 6; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_lr7 && frequency < RS125.threshold_lr8) {
    for (int i = 0; i < 2; i++) {
      pixels.setPixelColor(i, green);
    }
    for (int i = 2; i < 4; i++) {
      pixels.setPixelColor(i, yellow);
    }
    for (int i = 4; i < 6; i++) {
      pixels.setPixelColor(i, orange);
    }
    pixels.setPixelColor(6, red);
    pixels.setPixelColor(7, black);
  }
  else if (frequency >= RS125.threshold_lr8 && frequency < RS125.threshold_lr9) {
    for (int i = 0; i < 2; i++) {
      pixels.setPixelColor(i, green);
    }
    for (int i = 2; i < 4; i++) {
      pixels.setPixelColor(i, yellow);
    }
    for (int i = 4; i < 6; i++) {
      pixels.setPixelColor(i, orange);
    }
    for (int i = 6; i < 8; i++) {
      pixels.setPixelColor(i, red);
    }
  }
  else if (frequency >= RS125.threshold_lr9 && frequency <= RS125.max_revs) {
    for (int i = 0; i < 2; i++) {
      pixels.setPixelColor(i, green);
    }
    for (int i = 2; i < 4; i++) {
      pixels.setPixelColor(i, yellow);
    }
    for (int i = 4; i < 6; i++) {
      pixels.setPixelColor(i, orange);
    }
    for (int i = 6; i < 8; i++) {
      pixels.setPixelColor(i, red);
    }
    pixels.show();
    delay(blink_interval);
    for (int i = 0; i < 2; i++) {
      pixels.setPixelColor(i, green);
    }
    for (int i = 2; i < 4; i++) {
      pixels.setPixelColor(i, yellow);
    }
    for (int i = 4; i < 6; i++) {
      pixels.setPixelColor(i, orange);
    }
    for (int i = 6; i < 8; i++) {
      pixels.setPixelColor(i, black);
    }
    pixels.show();
    delay(blink_interval);
  }
  else if (frequency >= RS125.threshold_lr0 && frequency <= RS125.max_revs) {   // unterhalb der Warnschwelle bleiben alle lichter Schwarz geschalten
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black); // setze Pixel 0 bis 7 auf schwarz (alle 8)
    }
  }
  else {
    errorPrint();
  }
}
/*+++++++++++++++++++rainbow MODE+++++++++++++++++++++++++++++++++*/
void rainbow() {

  if (frequency >= RS125.threshold_lr1 && frequency < RS125.threshold_lr2) {
    pixels.setPixelColor(0, violet);
    for (int i = 1; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_lr2 && frequency < RS125.threshold_lr3) {
    pixels.setPixelColor(0, violet);
    pixels.setPixelColor(1, darkblue);
    for (int i = 2; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_lr3 && frequency < RS125.threshold_lr4) {
    pixels.setPixelColor(0, violet);
    pixels.setPixelColor(1, darkblue);
    pixels.setPixelColor(2, lightblue);
    for (int i = 3; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_lr4 && frequency < RS125.threshold_lr5) {
    pixels.setPixelColor(0, violet);
    pixels.setPixelColor(1, darkblue);
    pixels.setPixelColor(2, lightblue);
    pixels.setPixelColor(3, green);
    for (int i = 4; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_lr5 && frequency < RS125.threshold_lr6) {
    pixels.setPixelColor(0, violet);
    pixels.setPixelColor(1, darkblue);
    pixels.setPixelColor(2, lightblue);
    pixels.setPixelColor(3, green);
    pixels.setPixelColor(4, yellow);
    for (int i = 5; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_lr6 && frequency < RS125.threshold_lr7) {
    pixels.setPixelColor(0, violet);
    pixels.setPixelColor(1, darkblue);
    pixels.setPixelColor(2, lightblue);
    pixels.setPixelColor(3, green);
    pixels.setPixelColor(4, yellow);
    pixels.setPixelColor(5, orange);
    for (int i = 6; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black);
    }
  }
  else if (frequency >= RS125.threshold_lr7 && frequency < RS125.threshold_lr8) {
    pixels.setPixelColor(0, violet);
    pixels.setPixelColor(1, darkblue);
    pixels.setPixelColor(2, lightblue);
    pixels.setPixelColor(3, green);
    pixels.setPixelColor(4, yellow);
    pixels.setPixelColor(5, orange);
    pixels.setPixelColor(6, red);
    pixels.setPixelColor(7, black);
  }
  else if (frequency >= RS125.threshold_lr8 && frequency < RS125.threshold_lr9) {
    pixels.setPixelColor(0, violet);
    pixels.setPixelColor(1, darkblue);
    pixels.setPixelColor(2, lightblue);
    pixels.setPixelColor(3, green);
    pixels.setPixelColor(4, yellow);
    pixels.setPixelColor(5, orange);
    pixels.setPixelColor(6, red);
    pixels.setPixelColor(7, white);
  }
  else if (frequency >= RS125.threshold_lr9 && frequency <= RS125.max_revs) {
    pixels.setPixelColor(0, violet);
    pixels.setPixelColor(1, darkblue);
    pixels.setPixelColor(2, lightblue);
    pixels.setPixelColor(3, green);
    pixels.setPixelColor(4, yellow);
    pixels.setPixelColor(5, orange);
    pixels.setPixelColor(6, red);
    pixels.setPixelColor(7, white);
    pixels.show();
    delay(blink_interval);
    pixels.setPixelColor(0, violet);
    pixels.setPixelColor(1, darkblue);
    pixels.setPixelColor(2, lightblue);
    pixels.setPixelColor(3, green);
    pixels.setPixelColor(4, yellow);
    pixels.setPixelColor(5, orange);
    pixels.setPixelColor(6, red);
    pixels.setPixelColor(7, black);
    pixels.show();
    delay(blink_interval);
  }
  else if (frequency >= RS125.threshold_lr0 && frequency <= RS125.max_revs) {   // unterhalb der Warnschwelle bleiben alle lichter Schwarz geschalten
    for (int i = 0; i < NUMPIXELS; i++) {
      pixels.setPixelColor(i, black); // setze Pixel 0 bis 7 auf schwarz (alle 8)
    }
  }
  else {
    errorPrint();
  }
}
//***************************END of PROGRAM******************************************;
